﻿<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Handel.Forms" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Dokumenty sprzedaży</title>
		<script runat="server">
            /// <summary>
            /// Lista zmian:
            /// 2005-12-24:
            ///     1. Poprawiony błąd wyliczania wartości dokumentów sprzedaży licencji na dokumentach
            ///         z licencjami i usługami. Poprzednio wartośc licencji była zawyżana 
            ///         o wartość usług.
            ///     2. Dodano flagę pominSprzedażSoneta umożliwiającą analizę sprzedaży
            ///          z pominięciem sprzedaży wykonywanej bezpośrednio przez Sonetę 
            ///          (Prowizja dla==Soneta).
            /// 2005-12-26
            ///     1. Dodana informacja o rozrachunkach w poszczególnych kategoriach
            ///     2. Dodano możliwość grupowania łączenia obrotów pomiędzy różnymi kontrahentami
            /// </summary>
		    
	        static readonly bool ukryjKodyKontrahentów = false;
	        static readonly bool excel = false;
            static readonly bool pominSprzedażSoneta = false;

            class Item : IComparable {

                public int CompareTo(object v) {
                    return miesiąc.CompareTo(((Item)v).miesiąc);
                }

                readonly YearMonth miesiąc;
                decimal[] v = new decimal[3];
                int[] c = new int[3];
                decimal przeterminowane;

                public Item(YearMonth miesiąc) {
                    this.miesiąc = miesiąc;
                }

                public void Add(int kolor, decimal netto) {
                    v[kolor - 1] += netto;
                    c[kolor - 1]++;
                }
                public void Add(decimal przeterminowane) {
                    this.przeterminowane += przeterminowane;
                }

                public YearMonth Miesiąc {
                    get { return miesiąc; }
                }

                public decimal Srebrne {
                    get { return v[0]; }
                }
                public decimal Złote {
                    get { return v[1]; }
                }
                public decimal Platynowe {
                    get { return v[2]; }
                }
                public decimal SrebrneIl {
                    get { return c[0]; }
                }
                public decimal ZłoteIl {
                    get { return c[1]; }
                }
                public decimal PlatynoweIl {
                    get { return c[2]; }
                }
                public decimal SrebrneAvr {
                    get { return c[0] == 0 ? 0m : v[0] / c[0]; }
                }
                public decimal ZłoteAvr {
                    get { return c[1] == 0 ? 0m : v[1] / c[1]; }
                }
                public decimal PlatynoweAvr {
                    get { return c[2] == 0 ? 0m : v[2] / c[2]; }
                }
                public decimal Wartość {
                    get { return v[0] + v[1] + v[2]; }
                }
                public int Ilość {
                    get { return c[0] + c[1] + c[2]; }
                }
                public decimal Avr {
                    get { return Ilość == 0 ? 0m : Wartość / Ilość; }
                }
                public decimal Przeterminowane {
                    get { return przeterminowane; }
                }
                
            }

            class Pakiet : IComparable {

                public int CompareTo(object obj) {
                    return -Wartość.CompareTo(((Pakiet)obj).Wartość);
                }

                readonly int kolor;
                readonly string opis;
                decimal v, vklient;
                int c;
                decimal doRozliczenia;
                decimal przeterminowane;


                public Pakiet(int kolor, string opis) {
                    this.kolor = kolor;
                    this.opis = opis;
                }

                public void Add(decimal netto, decimal nettoKlient, DokumentHandlowy dokument) {
                    v += netto;
                    vklient += nettoKlient;
                    c++;

                    PłatnościDokumentuWorker worker = new PłatnościDokumentuWorker();
                    worker.Dokument = dokument;
                    this.przeterminowane += worker.Przeterminowane.Value;
                    this.doRozliczenia += worker.DoRozliczenia.Value;                                        
                }

                public string Kolor {
                    get {
                        switch (kolor) {
                            case 1: return "Srebrny";
                            case 2: return "Złoty";
                            case 3: return "Platynowy";
                        }
                        return "?";
                    }
                }
                public string Opis {
                    get { return opis; }
                }
                public decimal Wartość {
                    get { return v; }
                }
                public int Ilość {
                    get { return c; }
                }
                public decimal Avr {
                    get { return Wartość / Ilość; }
                }
                public decimal WartośćKlient {
                    get { return vklient; }
                }
                public decimal AvrKlient {
                    get { return WartośćKlient / Ilość; }
                }
                public string Podstawowy {
                    get { return c >= 10 ? "X" : ""; }
                }
                public decimal DoRozliczenia {
                    get { return doRozliczenia; }
                }
                public decimal Przeterminowane {
                    get { return przeterminowane; }
                }
            }

            class Partner : IComparable {

                public int CompareTo(object obj) {
                    int i = Aktywny.CompareTo(((Partner)obj).Aktywny);
                    if (i != 0)
                        return -i;
                    return -Wartość.CompareTo(((Partner)obj).Wartość);
                }

                readonly string kod;
                decimal v;
                int c;
                Hashtable pakiety = new Hashtable();
                decimal doRozliczenia;
                decimal przeterminowane;

                public Partner(string kod) {
                    this.kod = kod;
                }

                public void Add(Pakiet cfg, decimal netto, DokumentHandlowy dokument) {
                    object obj = pakiety[cfg];
                    if (obj == null)
                        pakiety.Add(cfg, 1);
                    else
                        pakiety[cfg] = (int)obj + 1;

                    v += netto;
                    c++;
                    
                    PłatnościDokumentuWorker worker = new PłatnościDokumentuWorker();
                    worker.Dokument = dokument;
                    this.przeterminowane += worker.Przeterminowane.Value;
                    this.doRozliczenia += worker.DoRozliczenia.Value;
                }

                public string Kod {
                    get { return kod; }
                }
                public decimal Wartość {
                    get { return v; }
                }
                public int Ilość {
                    get { return c; }
                }
                public decimal Avr {
                    get { return Ilość == 0 ? 0m : Wartość / Ilość; }
                }
                public string Aktywny {
                    get { return c >= 3 ? "X" : ""; }
                }
                public decimal DoRozliczenia {
                    get { return doRozliczenia; }
                }
                public decimal Przeterminowane {
                    get { return przeterminowane; }
                }

                public string Pakiety {
                    get {
                        ArrayList lista = new ArrayList();
                        foreach (DictionaryEntry item in pakiety) {
                            Pakiet p = (Pakiet)item.Key;
                            if (p.Podstawowy != "") {
                                int i = (int)item.Value;
                                string kolor = p.Kolor;
                                string opis = p.Opis;
                                lista.Add(kolor[0] + "/" + opis + ":" + i);
                            }
                        }

                        lista.Sort();
                        string result = "";
                        foreach (string s in lista)
                            if (result == "")
                                result = s;
                            else
                                result += ", " + s;

                        return result;
                    }
                }
            }

            class Kategoria : IComparable {

                public int CompareTo(object v) {
                    return miesiąc.CompareTo(((Kategoria)v).miesiąc);
                }

                readonly YearMonth miesiąc;
                decimal[] wartość = new decimal[3];
                int[] ilość = new int[3];
                
                public Kategoria(YearMonth miesiąc) {
                    this.miesiąc = miesiąc;
                }

                public void Add(DokumentHandlowy dokument, decimal netto) {
                    decimal pl = 0m, han = 0m, kh = 0m;
                    foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje) {
                        switch (pozycja.Towar.Features.GetString("Grupa")) {
                            case "Handel":
                                han += pozycja.Suma.Netto; break;
                            case "Księgowość":
                                kh += pozycja.Suma.Netto; break;
                            case "Płace":
                                pl += pozycja.Suma.Netto; break;
                        }
                    }

                    decimal v = pl + han + kh;
                    if (pl != 0)
                        ilość[0]++;
                    if (kh != 0)
                        ilość[1]++;
                    if (han != 0)
                        ilość[2]++;

                    pl *= netto / v;
                    kh *= netto / v;
                    han *= netto / v;
                    pl += netto - pl - kh - han;

                    if (pl + kh + han != netto)
                        Msg(dokument + " " + v + " " + netto + " " + (pl + kh + han));

                    wartość[0] += pl;
                    wartość[1] += kh;
                    wartość[2] += han;
                }

                public YearMonth Miesiąc {
                    get { return miesiąc; }
                }
                public decimal Kadry {
                    get { return wartość[0]; }
                }
                public int IlKadry {
                    get { return ilość[0]; }
                }
                public decimal AvrKadry {
                    get { return ilość[0] == 0 ? 0m : wartość[0] / ilość[0]; }
                }
                public decimal Ksiega {
                    get { return wartość[1]; }
                }
                public int IlKsiega {
                    get { return ilość[1]; }
                }
                public decimal AvrKsiega {
                    get { return ilość[1] == 0 ? 0m : wartość[1] / ilość[1]; }
                }
                public decimal Handel {
                    get { return wartość[2]; }
                }
                public int IlHandel {
                    get { return ilość[2]; }
                }
                public decimal AvrHandel {
                    get { return ilość[2] == 0 ? 0m : wartość[2] / ilość[2]; }
                }
                public decimal Razem {
                    get { return wartość[0] + wartość[1] + wartość[2]; }
                }
            }

            static bool TestDoc(DokumentHandlowy dokument) {
                return !pominSprzedażSoneta || KodPartnera(dokument).ToUpper() != "SONETA";
            }

            static decimal Przeterminowane(DokumentHandlowy dokument) {
                PłatnościDokumentuWorker worker = new PłatnościDokumentuWorker();
                worker.Dokument = dokument;
                return worker.Przeterminowane.Value;
            }
		    
            void OnContextLoad(Object sender, EventArgs args) {
                colKod.Visible = !ukryjKodyKontrahentów;

                Row[] rows = (Row[])dc[typeof(Row[])];

                Hashtable nowe = new Hashtable();
                Hashtable aktual = new Hashtable();
                Hashtable config = new Hashtable();
                Hashtable partners = new Hashtable();
                Hashtable kategorie = new Hashtable();

                foreach (DokumentHandlowy dokument in rows)
                    if (dokument.Definicja.Symbol == "FV" && TestDoc(dokument)) {
                        int kolor = KolorDokumentu(dokument);
                        string kod = KodPartnera(dokument);
                        if (kolor != 0) {
                            decimal przeterminowane = Przeterminowane(dokument);
                            bool nowa = NowaLicencja(dokument);

                            YearMonth m = new YearMonth(dokument.Data);

                            Item item;
                            if (nowa) {
                                item = (Item)nowe[m];
                                if (item == null)
                                    nowe.Add(m, item = new Item(m));
                            }
                            else {
                                item = (Item)aktual[m];
                                if (item == null)
                                    aktual.Add(m, item = new Item(m));
                            }
                            item.Add(kolor, Netto(dokument));
                            item.Add(przeterminowane);

                            if (nowa) {
                                string opis = KonfiguracjaLicencji(dokument);
                                Pakiet cfg = (Pakiet)config[kolor + opis];
                                if (cfg == null)
                                    config.Add(kolor + opis, cfg = new Pakiet(kolor, opis));
                                cfg.Add(Netto(dokument), NettoKlient(dokument), dokument);

                                //string kod = KodPartnera(dokument);
                                Partner partner = (Partner)partners[kod];
                                if (partner == null)
                                    partners.Add(kod, partner = new Partner(kod));
                                partner.Add(cfg, Netto(dokument), dokument);

                                Kategoria kat = (Kategoria)kategorie[m];
                                if (kat == null)
                                    kategorie.Add(m, kat = new Kategoria(m));
                                kat.Add(dokument, Netto(dokument));
                            }
                        }
                    }

                ArrayList lista = new ArrayList(nowe.Values);
                lista.Sort();
                Grid.DataSource = lista;

                ArrayList lista1 = new ArrayList(aktual.Values);
                lista1.Sort();
                Grid1.DataSource = lista1;

                ArrayList lista2 = new ArrayList(kategorie.Values);
                lista2.Sort();
                Grid2.DataSource = lista2;

                ArrayList lista3 = new ArrayList(config.Values);
                lista3.Sort();
                Grid3.DataSource = lista3;

                ArrayList lista4 = new ArrayList(partners.Values);
                lista4.Sort();
                Grid4.DataSource = lista4;

                if (excel) {
                    DokHandloweViewInfo.WParams wp = (DokHandloweViewInfo.WParams)dc[typeof(DokHandloweViewInfo.WParams)];
                    Response.Write("Podsumowanie sprzedaży\r\n");
                    Response.Write("Definicja: " + wp.Definicja + "\r\n");
                    Response.Write("Okres: " + wp.Okres + "\r\n");
                    Response.Write("Magazyn: " + wp.Magazyn + "\r\n");
                    Response.Write("Nabywca: " + wp.Kontrahent + "\r\n");

                    Response.Write("\r\n");
                    Response.Write("Nowe licencje\r\n");
                    Response.Write("LP;Miesiąc;S.Wartość;S.Ilość;S.Średnio;Z.Wartość;Z.Ilość;Z.Średnio;P.Wartość;P.Ilość;P.Średnio;Wartość;Ilość;Średnio\r\n");
                    int lp = 0;
                    foreach (Item item in lista)
                        Response.Write(string.Format("{0};{1};{2};{3};{4};{5};{6};{7};{8};{9};{10};{11};{12};{13}\r\n",
                            ++lp,
                            item.Miesiąc,
                            F(item.Srebrne),
                            item.SrebrneIl,
                            F(item.SrebrneAvr),
                            F(item.Złote),
                            item.ZłoteIl,
                            F(item.ZłoteAvr),
                            F(item.Platynowe),
                            item.PlatynoweIl,
                            F(item.PlatynoweAvr),
                            F(item.Wartość),
                            item.Ilość,
                            F(item.Avr)));

                    Response.Write("\r\n");
                    Response.Write("Aktualizacje\r\n");
                    Response.Write("LP;Miesiąc;S.Wartość;S.Ilość;S.Średnio;Z.Wartość;Z.Ilość;Z.Średnio;P.Wartość;P.Ilość;P.Średnio;Wartość;Ilość;Średnio\r\n");
                    lp = 0;
                    foreach (Item item in lista1)
                        Response.Write(string.Format("{0};{1};{2};{3};{4};{5};{6};{7};{8};{9};{10};{11};{12};{13}\r\n",
                            ++lp,
                            item.Miesiąc,
                            F(item.Srebrne),
                            item.SrebrneIl,
                            F(item.SrebrneAvr),
                            F(item.Złote),
                            item.ZłoteIl,
                            F(item.ZłoteAvr),
                            F(item.Platynowe),
                            item.PlatynoweIl,
                            F(item.PlatynoweAvr),
                            F(item.Wartość),
                            item.Ilość,
                            F(item.Avr)));

                    Response.Write("\r\n");
                    Response.Write("Moduły (nowe licencje)\r\n");
                    Response.Write("LP;Miesiąc;PL.Wartość;PL.Ilość;PL.Średnio;KH.Wartość;KH.Ilość;KH.Średnio;HAN.Wartość;HAN.Ilość;HAN.Średnio;Wartość\r\n");
                    lp = 0;
                    foreach (Kategoria item in lista2)
                        Response.Write(string.Format("{0};{1};{2};{3};{4};{5};{6};{7};{8};{9};{10};{11}\r\n",
                            ++lp,
                            item.Miesiąc,
                            F(item.Kadry),
                            item.IlKadry,
                            F(item.AvrKadry),
                            F(item.Ksiega),
                            item.IlKsiega,
                            F(item.AvrKsiega),
                            F(item.Handel),
                            item.IlHandel,
                            F(item.AvrHandel),
                            F(item.Razem)));

                    Response.Write("\r\n");
                    Response.Write("Konfiguracje (nowe licencje)\r\n");
                    Response.Write("LP;Podstawowy;Kolor;Opis;Ilość;P.Wartość;P.Średnio;K.Wartość;K.Średnio\r\n");
                    lp = 0;
                    foreach (Pakiet item in lista3)
                        Response.Write(string.Format("{0};{1};{2};{3};{4};{5};{6};{7};{8}\r\n",
                            ++lp,
                            item.Podstawowy,
                            item.Kolor,
                            item.Opis,
                            item.Ilość,
                            F(item.Wartość),
                            F(item.Avr),
                            F(item.WartośćKlient),
                            F(item.AvrKlient)));

                    Response.Write("\r\n");
                    Response.Write("Partnerzy (nowe licencje)\r\n");
                    Response.Write("LP;Aktywny;Kod;Wartość;Ilość;Średnio;Pakiety\r\n");
                    lp = 0;
                    foreach (Partner item in lista4)
                        Response.Write(string.Format("{0};{1};{2};{3};{4};{5};{6}\r\n",
                            ++lp,
                            item.Aktywny,
                            item.Kod,
                            F(item.Wartość),
                            item.Ilość,
                            F(item.Avr),
                            item.Pakiety));

                }
            }

            static string F(object v) {
                if (v == null)
                    return "";
                if (v is decimal)
                    return string.Format("{0:0.00}", v);
                return v.ToString();
            }

		/// <summary>
		/// Wartość netto pozycji 'oprogramowanie'
		/// </summary>
		/// <param name="dokument"></param>
		/// <returns></returns>
    
            decimal WartośćNettoZaOprogramowanie(DokumentHandlowy dokument) {
                decimal wartość = 0;
                foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje) {
                    switch (pozycja.Towar.Features.GetString("Grupa")) {
                        case "Handel":
                        case "Księgowość":
                        case "Płace":
                            wartość += pozycja.Suma.Netto; break;
                    }
                }

                return wartość;
            }
		    
            decimal Netto(DokumentHandlowy dokument) {
                decimal prowizja = dokument.Features.GetDecimal("Prowizja");
                return WartośćNettoZaOprogramowanie(dokument) - prowizja;
            }

            decimal NettoKlient(DokumentHandlowy dokument) {
                decimal wartość = 0;
                foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje) {
                    switch (pozycja.Towar.Features.GetString("Grupa")) {
                        case "Handel":
                        case "Księgowość":
                        case "Płace":
                            wartość += pozycja.WartośćPrzedRabatem.Value; break;
                    }
                }

                return wartość;
            }

            static string KodPartnera(DokumentHandlowy dokument) {
                CRMModule crm = CRMModule.GetInstance(dokument);
                Kontrahent kontrahent;
                string kod = dokument.Features.GetString("Prowizja dla");
                if (kod != "") {
                    kontrahent = crm.Kontrahenci.WgKodu[kod];
                    if (kontrahent == null)
                        throw new RowException(dokument, "Kontrahent o kodzie '" + kod + "' nie został znaleziony (" + dokument + ")");
                }
                else
                    kontrahent = dokument.Kontrahent;

                kod = kontrahent.Features.GetString("Prowizja dla");
                if (kod != "") {
                    kontrahent = crm.Kontrahenci.WgKodu[kod];
                    if (kontrahent == null)
                        throw new RowException(kontrahent, "Kontrahent o kodzie '" + kod + "' nie został znaleziony (" + kontrahent + ")");
                }
                return kontrahent.Kod;
            }

            bool NowaLicencja(DokumentHandlowy dokument) {
                foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje)
                    if (pozycja.Towar.Features.GetString("Licencja") == "Nowe")
                        return true;
                return false;
            }

            int KolorDokumentu(DokumentHandlowy dokument) {
                int kolor = 0;
                foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje) {
                    int k = 0;
                    switch (pozycja.Towar.Features.GetString("Kolor")) {
                        case "Srebrny":
                            k = 1; break;
                        case "Złoty":
                            k = 2; break;
                        case "Platynowy":
                            k = 3; break;
                    }
                    if (k > kolor)
                        kolor = k;
                }

                return kolor;
            }

            public string KonfiguracjaLicencji(DokumentHandlowy dokument) {
                Hashtable ht = new Hashtable();
                foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje) {
                    switch (pozycja.Towar.Features.GetString("Grupa")) {
                        case "Handel":
                        case "Księgowość":
                        case "Płace":
                            break;
                        default:
                            continue;
                    }

                    string nazwa = pozycja.Towar.Nazwa;
                    nazwa = nazwa.Substring(13, nazwa.Length - 13);
                    int i = nazwa.IndexOf(' ');
                    nazwa = (i == -1 ? nazwa : nazwa.Substring(0, i)).ToLower();
                    switch (nazwa) {
                        case "kadry":
                        case "biegli":
                        case "zarządzanie":
                            nazwa = "PL"; break;
                        case "handel": nazwa = "HAN"; break;
                        case "faktury": nazwa = "FA"; break;
                        case "książka": nazwa = "KP"; break;
                        case "akcyza":
                        case "excel":
                        case "księga": nazwa = "KH"; break;
                        case "windykacja": nazwa = "WND"; break;
                        case "crm": nazwa = "CRM"; break;
                        case "podgląd": nazwa = "POD"; break;
                        case "stanowisko": nazwa = "STM"; break;
                    }
                    ht[nazwa] = true;
                }

                ArrayList lista = new ArrayList(ht.Keys);
                lista.Sort();
                string konfiguracja = "";
                foreach (string s in lista)
                    if (konfiguracja == "")
                        konfiguracja = s;
                    else
                        konfiguracja += " " + s;

                return konfiguracja;
            }

            static void Msg(object value) {
            }
    
		</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<P><ea:datacontext id="dc" runat="server" Landscape="True" oncontextload="OnContextLoad"></ea:datacontext><eb:reportheader id="ReportHeader" title="Podsumowanie sprzedaży|</STRONG>Definicja:<STRONG> {1}|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}|</STRONG>Nabywca:<STRONG> {4}</STRONG>"
					runat="server" DataMember4="DokHandloweViewInfo+WParams.Kontrahent" DataMember3="DokHandloweViewInfo+WParams.Magazyn" DataMember2="DokHandloweViewInfo+WParams.Okres" DataMember1="DokHandloweViewInfo+WParams.Definicja"></eb:reportheader></P>
			<P><STRONG>Nowe licencje</STRONG><br>
				<ea:grid id="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server"></ea:GridColumn>
						<ea:GridColumn Width="16" Align="Center" DataMember="Miesiąc" Total="Info" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Srebrne" Total="Sum" Caption="srebrne~wartość" HideZero="True"
							Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="SrebrneIl" Total="Sum" Caption="srebrne~ilość" HideZero="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="SrebrneAvr" Caption="srebrne~średnio" HideZero="True"
							Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Złote" Total="Sum" Caption="złote~wartość" HideZero="True"
							Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="ZłoteIl" Total="Sum" Caption="złote~ilość" HideZero="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="ZłoteAvr" Caption="złote~średnio" HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Platynowe" Total="Sum" Caption="platynowe~wartość" HideZero="True"
							Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="PlatynoweIl" Total="Sum" Caption="platynowe~ilość" HideZero="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="PlatynoweAvr" Caption="platynowe~średnio" HideZero="True"
							Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Wartość" Total="Sum" Caption="razem~wartość" HideZero="True"
							Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Ilość" Total="Sum" Caption="razem~ilość" HideZero="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Avr" Caption="razem~średnio" HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Przetermi-nowane|(brutto)" Align="Right" DataMember="Przeterminowane" Format="{0:n}" HideZero="True" Total="Sum">
                        </ea:GridColumn>
					</Columns>
				</ea:grid><ea:pagebreak id="PageBreak3" runat="server"></ea:pagebreak></P>
			<P><STRONG>Aktualizacje</STRONG><br>
				<ea:grid id="Grid1" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server"></ea:GridColumn>
						<ea:GridColumn Width="16" Align="Center" DataMember="Miesiąc" Total="Info" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Srebrne" Total="Sum" Caption="srebrne~wartość" HideZero="True"
							Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="SrebrneIl" Total="Sum" Caption="srebrne~ilość" HideZero="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="SrebrneAvr" Caption="srebrne~średnio" HideZero="True"
							Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Złote" Total="Sum" Caption="złote~wartość" HideZero="True"
							Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="ZłoteIl" Total="Sum" Caption="złote~ilość" HideZero="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="ZłoteAvr" Caption="złote~średnio" HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Platynowe" Total="Sum" Caption="platynowe~wartość" HideZero="True"
							Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="PlatynoweIl" Total="Sum" Caption="platynowe~ilość" HideZero="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="PlatynoweAvr" Caption="platynowe~średnio" HideZero="True"
							Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Wartość" Total="Sum" Caption="razem~wartość" HideZero="True"
							Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Ilość" Total="Sum" Caption="razem~ilość" HideZero="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Avr" Caption="razem~średnio" HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
                        <ea:GridColumn runat="server" Align="Right" Caption="Przetermi-nowane|(brutto)" DataMember="Przeterminowane"
                            Format="{0:n}" HideZero="True" Total="Sum">
                        </ea:GridColumn>
					</Columns>
				</ea:grid>
				<ea:pagebreak id="PageBreak1" runat="server"></ea:pagebreak></P>
			<P><STRONG>Moduły (<EM>nowe licencje</EM>)</STRONG><br>
					<ea:grid id="Grid2" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
						<Columns>
							<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
							<ea:GridColumn Width="16" Align="Center" DataMember="Miesiąc" Total="Info"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Kadry" Total="Sum" Caption="Kadry i płace~wartość" HideZero="True"
								Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="IlKadry" Total="Sum" Caption="Kadry i płace~ilość" HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="AvrKadry" Caption="Kadry i płace~średnio" HideZero="True"
								Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Ksiega" Total="Sum" Caption="Księgowość~wartość" HideZero="True"
								Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="IlKsiega" Total="Sum" Caption="Księgowość~ilość" HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="AvrKsiega" Caption="Księgowość~średnio" HideZero="True"
								Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Handel" Total="Sum" Caption="Handel~wartość" HideZero="True"
								Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="IlHandel" Total="Sum" Caption="Handel~ilość" HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="AvrHandel" Caption="Handel~średnio" HideZero="True" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Razem" Total="Sum" HideZero="True" Format="{0:n}"></ea:GridColumn>
						</Columns>
					</ea:grid>
					<ea:pagebreak id="PageBreak2" runat="server"></ea:pagebreak></P>
			<P><STRONG>Konfiguracje <EM>(nowe licencje)</EM></STRONG><BR>
					<ea:grid id="Grid3" runat="server">
						<Columns>
							<ea:GridColumn Width="4" DataMember="#" Caption="LP." runat="server"></ea:GridColumn>
							<ea:GridColumn Width="10" Align="Center" DataMember="Podstawowy" Caption="Podsta-wowy" runat="server"></ea:GridColumn>
							<ea:GridColumn DataMember="Kolor" runat="server"></ea:GridColumn>
							<ea:GridColumn DataMember="Opis" runat="server"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Ilość" Total="Sum" HideZero="True" runat="server"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Wartość" Total="Sum" Caption="Partner~Wartość" HideZero="True"
								Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Avr" Caption="Partner~Średnio" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="WartośćKlient" Total="Sum" Caption="Klient~Wartość" HideZero="True"
								Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="AvrKlient" Caption="Klient~Średnio" HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
                            <ea:GridColumn runat="server" Caption="Rozliczenie (brutto)~pozostaje" DataMember="DoRozliczenia" Align="Right" Format="{0:n}" HideZero="True" Total="Sum">
                            </ea:GridColumn>
                            <ea:GridColumn runat="server" Align="Right" Caption="Rozliczenie (brutto)~przeterminowane" DataMember="Przeterminowane" Format="{0:n}" HideZero="True" Total="Sum">
                            </ea:GridColumn>
						</Columns>
					</ea:grid>
				<ea:pagebreak id="Pagebreak4" runat="server"></ea:pagebreak></P>
			<P><STRONG>Partnerzy <EM>(nowe licencje)</EM></STRONG> 
				<ea:grid id="Grid4" runat="server" ShowGroupSum="True">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server"></ea:GridColumn>
						<ea:GridColumn Width="8" Align="Center" DataMember="Aktywny" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="20" DataMember="Kod" ID="colKod" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Wartość" Total="Sum" HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Ilość" Total="Sum" HideZero="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Avr" Caption="Średnio" Format="{0:n}" runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="GridColumn1" runat="server" Caption="Rozliczenie (brutto)~pozostaje" DataMember="DoRozliczenia" Align="Right" Format="{0:n}" HideZero="True" Total="Sum">
                            </ea:GridColumn>
                            <ea:GridColumn ID="GridColumn2" runat="server" Align="Right" Caption="Rozliczenie (brutto)~przetermi-nowane" DataMember="Przeterminowane" Format="{0:n}" HideZero="True" Total="Sum">
                            </ea:GridColumn>
						<ea:GridColumn DataMember="Pakiety" runat="server" Width="60"></ea:GridColumn>
					</Columns>
				</ea:grid>
			</P>
			<P><eb:reportfooter id="ReportFooter" runat="server" TheEnd="False"></eb:reportfooter></P>
		</form>
	</body>
</HTML>

